# 画面設計書 23-Not Found（BlazorWebWasm）

## 概要

本ドキュメントは、BlazorWebWasm テストアセットにおける 404 エラーページ（NotFound.razor）の画面設計書です。存在しない URL にアクセスした場合に表示されるページとして実装されています。

### 本画面の処理概要

この画面は、Blazor WebAssembly アプリケーションで存在しないルートにアクセスした場合に表示される 404 Not Found ページです。シンプルなメッセージでユーザーにコンテンツが見つからないことを通知します。

**業務上の目的・背景**：本画面は .NET Runtime のテストアセットとして、Blazor WebAssembly アプリケーションにおける 404 エラーハンドリング機能を検証するために存在します。Router コンポーネントの `NotFoundPage` 属性により、マッチしないルートへのアクセス時に自動的に表示される仕組みをテストします。また、サーバーサイドでも `UseStatusCodePagesWithReExecute` により 404 ステータスコード時にこのページへリダイレクトされます。

**画面へのアクセス方法**：直接 `/not-found` パスにアクセスするか、アプリケーション内で存在しない URL にアクセスした際に自動的に表示されます。

**主要な操作・処理内容**：
1. "Not Found" 見出しを表示
2. コンテンツが見つからない旨のメッセージを表示
3. ユーザーはナビゲーションメニューを使用して他のページに遷移可能

**画面遷移**：本画面は 404 エラー時の終着点です。存在しない URL にアクセスした場合にルーターまたはサーバーミドルウェアによりリダイレクトされます。ユーザーはナビゲーションメニューを使用して Home ページや Counter ページに遷移できます。

**権限による表示制御**：本画面は認証・認可による表示制御を実装していません。すべてのユーザーがアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 2 | Mono | 主機能 | Blazor WebAssemblyランタイム上で404ページを表示 |
| 59 | WebAssembly Workload | 主機能 | Blazor WebAssemblyアプリケーションのビルドと実行をサポート |

## 画面種別

エラーページ / 404 Not Found

## URL/ルーティング

- **URL**: `/not-found`
- **レイアウト**: `@layout MainLayout`
- **レンダリングモード**: サーバーサイドレンダリング（SSR）

## 入出力項目

本画面には入出力項目はありません。

| 項目名 | 入出力 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| - | - | - | - | 入出力項目なし |

## 表示項目

| 項目名 | 表示形式 | データソース | 説明 |
|--------|----------|--------------|------|
| 見出し | h3 | 固定値 | "Not Found" |
| メッセージ | p | 固定値 | "Sorry, the content you are looking for does not exist." |

## イベント仕様

本画面にはユーザー操作によるイベントはありません。

## データベース更新仕様

### 操作別データベース影響一覧

本画面はデータベースとの連携を行いません。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | データベース操作なし |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|---------|
| MSG-001 | 情報 | "Not Found" | 常時表示 |
| MSG-002 | 情報 | "Sorry, the content you are looking for does not exist." | 常時表示 |

## 例外処理

| 例外種別 | 発生条件 | 対処 |
|---------|---------|------|
| 該当なし | 404 ページ自体では例外処理は行わない | - |

## 備考

- 本画面は `.NET Runtime` リポジトリのテストアセットであり、Blazor WebAssembly の 404 エラーハンドリング機能を検証する目的で作成されています。
- Router コンポーネントの `NotFoundPage` 属性により、クライアントサイドルーティングでも使用されます。
- `@layout MainLayout` ディレクティブにより、アプリケーションの標準レイアウト内で表示されます。
- サーバーサイドでは `UseStatusCodePagesWithReExecute("/not-found")` により 404 ステータスコード時に再実行されます。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

本画面は静的なコンテンツのみを表示するため、データ構造は存在しません。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | NotFound.razor | `src/mono/wasm/testassets/BlazorWebWasm/BlazorWebWasm/Components/Pages/NotFound.razor` | シンプルな静的コンテンツ構造を確認（全5行） |

**読解のコツ**: `@layout` ディレクティブにより、このコンポーネントは MainLayout 内でレンダリングされます。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Routes.razor | `src/mono/wasm/testassets/BlazorWebWasm/BlazorWebWasm/Components/Routes.razor` | NotFoundPage 属性の設定（1行目）を確認 |
| 2-2 | Program.cs | `src/mono/wasm/testassets/BlazorWebWasm/BlazorWebWasm/Program.cs` | UseStatusCodePagesWithReExecute の設定（42行目）を確認 |

**主要処理フロー**:
1. **Routes.razor 1行目**: `NotFoundPage="typeof(Pages.NotFound)"` でルーターの 404 ページを指定
2. **Program.cs 42行目**: `app.UseStatusCodePagesWithReExecute("/not-found")` でサーバーサイド 404 ハンドリングを設定

#### Step 3: コンポーネント実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | NotFound.razor | `src/mono/wasm/testassets/BlazorWebWasm/BlazorWebWasm/Components/Pages/NotFound.razor` | ページディレクティブとレイアウト指定 |

**主要処理フロー**:
- **1行目**: `@page "/not-found"` でルーティングパスを定義
- **2行目**: `@layout MainLayout` でレイアウトを明示的に指定
- **4-5行目**: 静的な見出しとメッセージを表示

### プログラム呼び出し階層図

```
存在しないURLへのアクセス
    │
    ├─ [クライアントサイド] Router
    │      │
    │      └─ NotFoundPage 属性
    │             │
    │             └─ NotFound.razor
    │
    └─ [サーバーサイド] UseStatusCodePagesWithReExecute
           │
           └─ 404 ステータスコード
                  │
                  └─ /not-found へ再実行
                         │
                         └─ NotFound.razor
                                │
                                └─ MainLayout.razor
                                       │
                                       └─ @Body（NotFound コンテンツ）
```

### データフロー図

```
[入力]                    [処理]                     [出力]

存在しない URL ──────▶ Router / StatusCodePages
                              │
                              ▼
                        NotFound.razor
                              │
                              ▼
                        MainLayout.razor ────────▶ 画面表示
                                                   "Not Found"
                                                   "Sorry, the content..."
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| NotFound.razor | `src/mono/wasm/testassets/BlazorWebWasm/BlazorWebWasm/Components/Pages/NotFound.razor` | ソース | 404 ページのメインコンポーネント |
| Routes.razor | `src/mono/wasm/testassets/BlazorWebWasm/BlazorWebWasm/Components/Routes.razor` | ソース | ルーティング設定（NotFoundPage 属性） |
| Program.cs | `src/mono/wasm/testassets/BlazorWebWasm/BlazorWebWasm/Program.cs` | ソース | サーバーサイドエントリーポイント（ステータスコードハンドリング） |
| MainLayout.razor | `src/mono/wasm/testassets/BlazorWebWasm/BlazorWebWasm/Components/Layout/MainLayout.razor` | ソース | アプリケーションレイアウト |
| NavMenu.razor | `src/mono/wasm/testassets/BlazorWebWasm/BlazorWebWasm/Components/Layout/NavMenu.razor` | ソース | ナビゲーションメニュー |
